// super-unsafe-server.js
// 完全に自分用。セキュリティゼロ。

const express = require('express');
const bodyParser = require('body-parser');
const cors = require('cors');
const { spawn, exec } = require('child_process');
const path = require('path');

const app = express();

app.use(cors());
app.use(bodyParser.json());

const procs = new Map();

// ------------------------------
// POST /start
// ------------------------------
app.post('/start', (req, res) => {
  const dir = req.body.dir;
  if (!dir) return res.status(400).send("dir required");

  const full = path.resolve(__dirname, dir);

  let cmd, args;
  if (full.endsWith('.js')) {
    cmd = process.execPath;
    args = [full];
  } else {
    cmd = full;
    args = [];
  }

  const child = spawn(cmd, args, {
    detached: true,
    stdio: 'ignore',
    windowsHide: true,
    cwd: path.dirname(full)
  });

  child.unref();

  const id = `${Date.now()}-${child.pid}`;

  // ★ ここを拡張
  procs.set(id, {
    pid: child.pid,
    path: full,
    started: Date.now()
  });

  console.log(`STARTED: ${full} pid=${child.pid}`);

  res.json({ ok: true, id, pid: child.pid });
});

// ------------------------------
// POST /kill
// ------------------------------
app.post('/kill', (req, res) => {
  const pid = Number(req.body.pid);
  if (!pid) return res.status(400).send("pid required");

  exec(`taskkill /PID ${pid} /T /F`, (err, stdout, stderr) => {
    if (err) return res.status(500).send(stderr || err.message);

    // ★ kill したら procs から削除
    for (const [id, info] of procs.entries()) {
      if (info.pid === pid) procs.delete(id);
    }

    console.log(`KILLED: pid=${pid}`);
    res.json({ ok: true, pid });
  });
});

// ------------------------------
// GET /list
// 現在生きているプロセスだけ返す
// ------------------------------
app.get('/list', (req, res) => {
  exec('tasklist /FO CSV', (err, stdout) => {
    if (err) return res.status(500).send(err.message);

    const alivePids = new Set();

    // CSV を解析して PID を抽出
    const lines = stdout.split('\n').slice(1);
    for (const line of lines) {
      const cols = line.split('","');
      if (cols.length > 1) {
        const pid = Number(cols[1].replace(/"/g, ''));
        if (!isNaN(pid)) alivePids.add(pid);
      }
    }

    const list = [];

    for (const [id, info] of procs.entries()) {
      if (alivePids.has(info.pid)) {
        list.push({
          id,
          pid: info.pid,
          path: info.path,
          started: info.started
        });
      } else {
        // ★ 死んでるプロセスは自動削除
        procs.delete(id);
      }
    }

    res.json(list);
  });
});

// ------------------------------
app.listen(3000, () => {
  console.log("UNSAFE process server running on 3000");
});
